from datetime import datetime
import json
from jose import jwt
from hashlib import md5
import requests

from dotenv import load_dotenv
import os

load_dotenv()

api_key = os.environ.get("API_KEY")

# api_key = '<<SUA API KEY>>'

def create_encoded_header(endpoint, body, method):
    client_private_key = '''-----BEGIN EC PRIVATE KEY-----
    <<SUA PRIVATE KEY>>
    -----END EC PRIVATE KEY-----'''

    today_str = datetime.utcnow().strftime("%Y-%m-%dT%H:%M:%S")

    dict_to_sign = {"timestamp": today_str, "method": method, "uri": endpoint}

    body_bytes = json.dumps(body).encode()

    md5_instance = md5()
    md5_instance.update(body_bytes)
    md5_body = md5_instance.hexdigest()


    dict_to_sign["payload_md5"] = md5_body

    jwt_headers = {"alg": "ES512", "typ": "JWT"}
    encoded_header_token = jwt.encode(
        claims=dict_to_sign,
        key=client_private_key,
        algorithm="ES512",
        headers=jwt_headers,
    )
    return encoded_header_token

FUND_CLASS_KEY = ''
ASSIGNMENT_CONFIGURATION_KEY = ''
BASE_URL = f'fund_class/{FUND_CLASS_KEY}/assignment_configuration/{ASSIGNMENT_CONFIGURATION_KEY}'
EXTERNAL_ID = ''

base_url = "https://manager-api.sandbox.qidtvm.com.br"
endpoint = f"/trade_receivables/{BASE_URL}/assignment/{EXTERNAL_ID}/asset"
method = "POST"

body = {
    "asset_type": "duplicata_mercantil",
    "total_purchase_value": 1231.21,
    "discounted_credit_right": {
        "external_id": "e292656f-f7fb-44dc-96f3-667c36c88442",
        "originator_document_number": "53.020.654/0001-43",
        "maturity_date": "2050-12-10",
        "order_number": "18923619954796912",
        "face_value": 1450.02,
        "person_type": "natural_person",
        "borrower": {
            "name": "U cara",
            "document_number": "805.359.140-08",
            "person_type": "natural_person",
            "email": "theguy@yopmail.com",
            "address": {
                "street": "Gilberto Sabino",
                "number": "215",
                "neighborhood": "Pinheiros",
                "city": "São Paulo",
                "postal_code": "05425-020",
                "uf": "SP",
                "country": "BRA"
            },
            "phone": {
                "area_code": "11",
                "number": "36360268"
            },
            "natural_person": {
                "mother_name": "Lívia Santos",
                "birthdate": "2001-01-05"
            }
        },
        "participant_control_number": "ICX841HWCPUGU4U101XPLDW8D",
        "bankslip": { 
            "our_number": {
                "number": "15948261594",
                "digit": "P" 
            }
        },        
        "delay": {  
            "fine": {
                "fine_type": "percentage", 
                "percentage_value": 0.0   
            },
            "interest": {
                "method": "pre_fixed",  
                "pre_fixed": {
                    "daily_rate": 0.0, 
                    "calendar_base": "calendar_360"
                }
            }
        },
        "invoice": {
            "access_key": "69037229347091328617032722238810300308237163",
            "total_value": 1450.02,
            "serie": "123",
            "number": "958431587",
            "issue_date": "2023-10-10"
        }       
    }
}


encoded_header_token = create_encoded_header(endpoint, body, method=method)

headers = {"API-CLIENT-KEY": api_key, "AUTHORIZATION": encoded_header_token}

url = f"{base_url}{endpoint}"

resp = requests.post(url=url, headers=headers, json=body)
print(resp.json())
